/*
 * Decompiled with CFR 0.152.
 */
package de.yaxgl.EventDispatcher;

import de.yaxgl.Base.Component;
import de.yaxgl.EventDispatcher.Attribute.EventType;
import de.yaxgl.EventDispatcher.EventArgs;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EventHandlerMethod {
    private Object eventReciever;
    private Method methodInfo;
    private EventType eventType;
    private String eventID;
    private boolean regexOn;

    public EventHandlerMethod(Object eventReciever, Method methodInfo, EventType eventType, String eventID, boolean regexOn) {
        this.eventReciever = eventReciever;
        this.methodInfo = methodInfo;
        this.eventType = eventType;
        this.eventID = eventID;
        this.regexOn = regexOn;
    }

    public boolean isMatching(String eventID) {
        boolean retVal;
        if (this.regexOn) {
            Pattern p = Pattern.compile("^" + this.eventID + "$");
            Matcher m = p.matcher(eventID);
            retVal = m.matches();
        } else {
            retVal = this.eventID.equals(eventID);
        }
        return retVal;
    }

    public boolean isTypeOf(EventType eventType) {
        return this.eventType == eventType;
    }

    public void invokeMethod(Component component, EventArgs eventArgs) {
        Object[] arg = new Object[]{component, eventArgs};
        try {
            this.methodInfo.invoke(this.eventReciever, arg);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

