/*
 * Decompiled with CFR 0.152.
 */
package de.yaxgl.EventDispatcher;

import de.yaxgl.Base.Component;
import de.yaxgl.EventDispatcher.Attribute.EventHandler;
import de.yaxgl.EventDispatcher.Attribute.EventType;
import de.yaxgl.EventDispatcher.EventArgs;
import de.yaxgl.EventDispatcher.EventHandlerMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class EventHandlerManager {
    List<EventHandlerMethod> eventHandlerMethods = new ArrayList<EventHandlerMethod>();

    public void registerEventHandlers(Object eventReciever) throws Exception {
        Method[] methodArray = eventReciever.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Annotation[] annotations = method.getAnnotations();
            if (annotations.length > 0) {
                Annotation[] annotationArray = annotations;
                int n3 = annotations.length;
                int n4 = 0;
                while (n4 < n3) {
                    Annotation annotation = annotationArray[n4];
                    if (annotation.annotationType().equals(EventHandler.class)) {
                        EventType eventType = ((EventHandler)annotation).eventType();
                        String eventID = ((EventHandler)annotation).eventID();
                        boolean regexOn = ((EventHandler)annotation).regexOn();
                        if (method.getParameterTypes().length < 2 && method.getParameterTypes().length > 3) {
                            throw new Exception("Event handler must have exactly 2 Arguments.");
                        }
                        Class<?> componentParameter = method.getParameterTypes()[0];
                        Class<?> argParameter = method.getParameterTypes()[1];
                        if (!componentParameter.equals(Component.class) || !argParameter.equals(EventArgs.class)) {
                            throw new Exception("Event Handler must have 2 Arguments with Type " + EventType.class.toString() + " and " + String.class.toString() + ".");
                        }
                        EventHandlerMethod eventHandlerMethod = new EventHandlerMethod(eventReciever, method, eventType, eventID, regexOn);
                        this.eventHandlerMethods.add(eventHandlerMethod);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public void invokeHandlers(Component component, EventArgs eventArgs) {
        for (EventHandlerMethod eventHandlerMethod : this.eventHandlerMethods) {
            if (!eventHandlerMethod.isTypeOf(eventArgs.getType()) || !eventHandlerMethod.isMatching(eventArgs.getID())) continue;
            eventHandlerMethod.invokeMethod(component, eventArgs);
        }
    }
}

