/*
 * Decompiled with CFR 0.152.
 */
package de.yaxgl.Container;

import de.yaxgl.Container.Window;
import de.yaxgl.Helper.LookAndFeel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class WindowManager {
    List<Window> windows = new ArrayList<Window>();
    private static WindowManager instance = null;
    private static boolean initialized = false;
    private static Display display = null;

    private WindowManager() {
    }

    public static void initialize(LookAndFeel lookAndFeel) throws Exception {
        if (lookAndFeel != LookAndFeel.System) {
            throw new Exception("The selected LookAndFeel is not supported.");
        }
        initialized = true;
    }

    public static WindowManager getInstance() throws Exception {
        if (!initialized) {
            throw new Exception("The WindowManager must be initialized before you can have an instance.");
        }
        if (instance == null) {
            display = new Display();
            instance = new WindowManager();
        }
        return instance;
    }

    public Window createWindow(String xmlfile, Object EventReciever) {
        Window window = new Window(display, xmlfile);
        window.registerEventHandlers(EventReciever);
        this.windows.add(window);
        return window;
    }

    public void run(Window baseWindow) {
        Shell shell = null;
        if (baseWindow != null) {
            shell = (Shell)baseWindow.getNativeComponent();
            baseWindow.show();
        }
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public void show(Window window) {
        if (window != null) {
            window.show();
        }
    }

    public void showModal(Window window, Window parentWindow) {
        if (window != null) {
            window.showDialog(parentWindow);
        }
    }

    public void hide(Window window) {
        if (window != null) {
            window.hide();
        }
    }

    public void close(Window window) {
        if (window != null) {
            if (this.windows.contains(window)) {
                this.windows.remove(window);
            }
            window.close();
        }
    }

    public List<Window> getWindowsByID(String ID) {
        ArrayList<Window> matchingWindows = new ArrayList<Window>();
        for (Window window : this.windows) {
            if (!window.getID().equals(ID)) continue;
            matchingWindows.add(window);
        }
        return matchingWindows;
    }
}

