/*
 * Decompiled with CFR 0.152.
 */
package de.yaxgl.Container;

import de.yaxgl.Base.Component;
import de.yaxgl.Container.Container;
import de.yaxgl.EventDispatcher.EventArgs;
import de.yaxgl.EventDispatcher.EventHandlerManager;
import de.yaxgl.Helper.WindowStyle;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Element;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class Window
extends Container {
    private EventHandlerManager eventHandlerManager = null;
    private Display display = null;

    public Window(Display display, String xmlfile) {
        this.display = display;
        this.owner = null;
        this.eventHandlerManager = new EventHandlerManager();
        Element rootElement = this.validateXmlDocument(xmlfile);
        this.parseXML(rootElement);
    }

    public void registerEventHandlers(Object eventReciever) {
        if (eventReciever != null) {
            try {
                this.eventHandlerManager.registerEventHandlers(eventReciever);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void initializeNativeControl(Element xmlElement) {
        String borderStyle;
        int style = 1264;
        this.ID = xmlElement.getAttribute("id");
        if (!Boolean.valueOf(xmlElement.getAttribute("minimizeBox")).booleanValue()) {
            style -= 128;
        }
        if (!Boolean.valueOf(xmlElement.getAttribute("maximizeBox")).booleanValue()) {
            style -= 1024;
        }
        if ((borderStyle = xmlElement.getAttribute("borderStyle")).equals("fixed")) {
            style -= 16;
        } else if (borderStyle.equals("none")) {
            style = 0;
        }
        this.control = new Shell(this.display, style);
        this.setBounds(Integer.valueOf(xmlElement.getAttribute("xpos")), Integer.valueOf(xmlElement.getAttribute("ypos")), Integer.valueOf(xmlElement.getAttribute("width")), Integer.valueOf(xmlElement.getAttribute("height")));
        this.setTitle(xmlElement.getAttribute("title"));
        this.setIcon(xmlElement.getAttribute("icon"));
    }

    @Override
    public void notifyEvent(Component control, EventArgs eventArgs) {
        this.eventHandlerManager.invokeHandlers(control, eventArgs);
    }

    public Display getDisplay() {
        return this.display;
    }

    public void showInTaskbar(boolean show) {
    }

    public void setBorderStyle(WindowStyle windowStyle) {
        throw new NotImplementedException();
    }

    public void minimizeable(boolean minimize) {
        throw new NotImplementedException();
    }

    public void maximizeable(boolean maximize) {
        throw new NotImplementedException();
    }

    public void setIcon(String icon) {
        Image image = null;
        try {
            image = new Image((Device)((Shell)this.control).getDisplay(), (InputStream)new FileInputStream(icon));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        ((Shell)this.control).setImage(image);
    }

    public String getTitle() {
        return ((Shell)this.control).getText();
    }

    public void setTitle(String title) {
        ((Shell)this.control).setText(title);
    }

    public void show() {
        ((Shell)this.control).open();
    }

    public void showDialog(Window parentWindow) {
        if (parentWindow != null) {
            this.owner = parentWindow;
            ((Shell)this.control).setParent((Composite)parentWindow.getNativeComponent());
        }
        ((Shell)this.control).open();
    }

    public void hide() {
        ((Shell)this.control).setVisible(false);
    }

    public void close() {
        ((Shell)this.control).close();
    }
}

