/*
 * Decompiled with CFR 0.152.
 */
package de.yaxgl.Container;

import de.yaxgl.Base.Component;
import de.yaxgl.Base.Containable;
import de.yaxgl.EventDispatcher.EventArgs;
import de.yaxgl.Helper.Dimension;
import de.yaxgl.SimpleComponentFactory;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.swt.widgets.Control;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class Container
extends Component {
    private Map<String, Containable> components = new Hashtable<String, Containable>();

    public abstract void notifyEvent(Component var1, EventArgs var2);

    public void add(Containable containable) {
        if (containable != null && !this.components.containsKey(((Component)((Object)containable)).getID())) {
            Component newComponent = (Component)((Object)containable);
            this.components.put(newComponent.getID(), containable);
        }
    }

    public void remove(Containable containable) {
        if (containable != null && this.components.containsKey(((Component)((Object)containable)).getID())) {
            ((Control)((Component)((Object)containable)).getNativeComponent()).dispose();
            this.components.remove(((Component)((Object)containable)).getID());
        }
    }

    public Component getComponentById(String ID) {
        if (this.components.containsKey(ID)) {
            return (Component)((Object)this.components.get(ID));
        }
        return null;
    }

    protected Element validateXmlDocument(String xmlfile) {
        Document xmlDocument = null;
        DocumentBuilder builder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        try {
            xmlDocument = builder.parse(new File(xmlfile));
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return xmlDocument.getDocumentElement();
    }

    protected void parseXML(Element rootElement) {
        if (rootElement.getNodeName().equals("yaxgl:window")) {
            this.initializeNativeControl(rootElement);
        } else if (rootElement.getNodeName().equals("yaxgl:group")) {
            Dimension dimension = new Dimension(Integer.valueOf(rootElement.getAttribute("width")), Integer.valueOf(rootElement.getAttribute("height")));
            this.setDimension(dimension);
        }
        NodeList childNodes = rootElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            if (childNodes.item(i).getNodeType() == 1) {
                Element xmlElement = (Element)childNodes.item(i);
                this.add(SimpleComponentFactory.createComponent(this, xmlElement));
            }
            ++i;
        }
    }
}

